#ifndef PALXMLFACTORY_H
#define PALXMLFACTORY_H

#include "palFactory.h"
#include "../tinyxml/tinyxml.h"
//#include "../pal_i/newton_pal.h"

/*
	Abstract:
		PAL XML Factory -	Physics Abstraction Layer. 
							The factory required to create all objects via XML files
	
	Author: 
		Adrian Boeing
	Revision History:
		Version 0.15: 11/08/04 - generic link loading
		Version 0.15: 08/08/04 - Added materials, seperate group vectors
		Version 0.11: 05/07/04 - Generic body support & compound objects & geometries
		Version 0.1 : 28/06/04 
	TODO:
		- fix bodies so they dont need a "parameter" lookup
		- try and fix global name lookup issues
*/

/** The XML loader class.
	The XML factory calls the palFactory to produce all the components required. 
	It simply provides an XML interface to the palFactory initialization routines.
	
	Objects created with the XML factory can be acquired via the palGetObject routine.
*/
class palXMLFactory : private palFactory {
public:
	/** Loads a specified XML file.
	*/
	int LoadXML(char *filename);
protected:
	void palPutObject(STRING name, palFactoryObject *ptr);
	int LoadTerrain(TiXmlElement* terrainElement);
	int LoadPrimitives(TiXmlElement* primitiveElement);
	int LoadLinks(TiXmlElement* linkElement);
	int LoadSensors(TiXmlElement* sensorElement);
	int LoadActuators(TiXmlElement* actuatorElement);
	int LoadMaterials(TiXmlElement* materialElement);
private:
	int Read(TiXmlElement* element, char *name, int num, char *label_dest, ...);
public:
	VECTOR<palTerrain *> m_Terrain;
	VECTOR<palBody *> m_Bodies;
	VECTOR<palActuator *> m_Actuators;
	VECTOR<palSensor *> m_Sensors;
	VECTOR<palLink *> m_Links;
};


extern MAP<STRING,palFactoryObject *> g_NameMap;

template <typename T> T *palGetObject(STRING name) {
	MAP<STRING,palFactoryObject *> ::iterator itr;
	itr=g_NameMap.find(name);
	if (itr!=g_NameMap.end()) {
		T * pT = dynamic_cast<T *> ((*itr).second);
		return pT;
	} 
	printf("could not find %s\n",name.c_str());
	return NULL;
}

#endif