#ifndef FACTORYCONFIG_H
#define FACTORYCONFIG_H
//(c) Adrian Boeing 2004, see liscence.txt (BSD liscence)
/*
	Abstract:
		The "configuration" setting for the factory templates I choose to use.
	Author: 
		Adrian Boeing
	Revision History:
		Version 1.0.4 18/08/04 PAL modifications
		Version 1.0.3 04/08/04 Virtual freeobjects
		Version 1.0.2:12/06/04 Debugging methods - dont compile with VC6 - speed optimizations
		Version 1.0.1:19/01/04 LoadObjects win32 bugfix
		Version 1.0 : 14/01/04 
	TODO:
		proper virtual inheritance of free objects
*/
//#define INTERNAL_DEBUG
#ifdef INTERNAL_DEBUG
#include <stdio.h>
#endif

//#include "statushelpers.h"
#include "factory.h" 
#include "statusobject.h"
#include "managedmemoryobject.h"
//#include "serialize.h" //need this to support dynamic loading of serializable objects (jic)

typedef ManagedMemoryObject<StatusObject> myFactoryBase;
//typedef GroupVersionInfo<myFactoryBase> myFactoryInfo;
//#define myFactoryParameters myFactoryInfo,myFactoryBase 
typedef RegistrationInfo<myFactoryBase> myFactoryInfo;
#define myFactoryParameters myFactoryBase 
typedef FactoryObject<myFactoryBase> myFactoryObject;
typedef PluggableFactory<myFactoryBase> myPluggableFactory;

class myFactory : public myPluggableFactory, public MemoryObjectManager<StatusObject> {
public:
	static void LoadObjects(char *szPath = NULL);
	virtual void FreeObjects(void);
	myFactoryObject *Construct(STRING ClassName);
	void DisplayAllObjects();
};
#ifdef INTERNAL_DEBUG
#define FACTORY_CLASS(name,ClassName,GroupName,Version) public: \
	name(FactoryStaticRegisterVariable reg) { \
		 RegisterWithFactory(PluggableFactory<myFactoryParameters>::sInfo());} \
void RegisterWithFactory(VECTOR<myFactoryInfo> &lsInfo) { \
		myFactoryInfo ri; \
		ri.mUniqueName=#name; \
		ri.mClassName=#ClassName; \
		ri.mVersion=Version; \
		ri.mGroupName=#GroupName; \
		ri.mConstructor=(myFactoryObject *) this; \
		printf("registering %s with %d (size:%d)\n",#name,&lsInfo,lsInfo.size()); \
		Register(ri,lsInfo); \
} \
myFactoryObject* Create() {return new name;} \
	private:
#else
#define FACTORY_CLASS(name,ClassName,GroupName,Version) public: \
name(FactoryStaticRegisterVariable reg) { \
		 RegisterWithFactory(PluggableFactory<myFactoryParameters>::sInfo());} \
void RegisterWithFactory(VECTOR<myFactoryInfo> &lsInfo) { \
		myFactoryInfo ri; \
		ri.mUniqueName=#name; \
		ri.mClassName=#ClassName; \
		ri.mVersion=Version; \
		ri.mGroupName=#GroupName; \
		ri.mConstructor=(myFactoryObject *) this; \
		Register(ri,lsInfo); \
} \
myFactoryObject* Create() {return new name;} \
	private:
#endif //INTERNAL_DEBUG

#endif

