#include "errorlog.h"
//(c) Adrian Boeing 2004, see liscence.txt (BSD liscence)
/*
	Abstract:
		ErrorLog		-	PAL version
	
	Author: 
		Adrian Boeing
	Revision History:
		Version 0.1: 19/08/04
	
	TODO:
*/

ErrorLog *ErrorLog::m_pInstance;

ErrorLog::ErrorLog() {
#ifdef NDEBUG
		m_DebugAlertLevel = 0;
#else
		m_DebugAlertLevel = 1;
#endif
		m_DebugLevel = 1;
		char buf[4096];
		OS_snprintf(buf,4096,"Error Log Initialized. Compiled:%s %s\n",__TIME__,__DATE__);
		WriteLog("----------------------------------------\n");
		WriteLog(buf);
		WriteLog("---------------------------------------:\n");
	}
	void ErrorLog::SetInfo(char *FileName, long Line, StatusObject *pObject, char *Type) {
		m_infoFileName = FileName;
		m_infoLine = Line;
		m_infopObject = pObject;
		m_infoType = Type;
	}
	void ErrorLog::CriticalError(char *Message, ...) {
		char buf[4096];
		va_list ap;
		va_start(ap, Message);
		OS_vsnprintf(buf, 4096, Message, ap);
		va_end(ap);
		DoLog(buf);
		StatusObject *pSO = (StatusObject *)m_infopObject;
		pSO->SetStatus(SCRITICALERROR);
		throw std::runtime_error(buf);
	}
	
	void ErrorLog::Error(char *Message, ...) {
		char buf[4096];
		va_list ap;
		va_start(ap, Message);
		OS_vsnprintf(buf, 4096, Message, ap);
		va_end(ap);
		DoLog(buf);
		StatusObject *pSO = (StatusObject *)m_infopObject;
		if (pSO)
			pSO->SetStatus(SERROR);
	}
	void ErrorLog::Warning(char *Message, ...) {
		char buf[4096];
		va_list ap;
		va_start(ap, Message);
		OS_vsnprintf(buf, 4096, Message, ap);
		va_end(ap);
		DoLog(buf);
		StatusObject *pSO = (StatusObject *)m_infopObject;
		pSO->SetStatus(SWARNING);
	}
	void ErrorLog::Debug(char *Message, ...) {
		if (m_DebugLevel>m_DebugAlertLevel) return;
		char buf0[4096];
		char buf1[4096];
		va_list ap;
		va_start(ap, Message);
		OS_vsnprintf(buf0, 4096, Message, ap);
		va_end(ap);
		
		OS_snprintf(buf1,4096,"l(%d):%s",m_DebugLevel,buf0);
		DoLog(buf1);
	}
	int  ErrorLog::GetDebugLevel() {
		return m_DebugLevel;
	}
	void ErrorLog::SetDebugLevel(int Level) {
		m_DebugLevel=Level;
	}
	int  ErrorLog::GetDebugAlertLevel() {
		return m_DebugAlertLevel;
	}
	void ErrorLog::SetDebugAlertLevel(int Level) {
		m_DebugAlertLevel=Level;
	}
	ErrorLog *ErrorLog::GetInstance() {
		if (m_pInstance == NULL) 
			m_pInstance = new ErrorLog;
		return m_pInstance;
	}
	void ErrorLog::DoLog(char *Message) {
		char sz[8096];
		OS_snprintf(sz,8192,"%s:%d: Object:(0x%.8x) : (%s): %s\n",m_infoFileName,m_infoLine,m_infopObject,m_infoType,Message);
		WriteLog(sz);
	}
	void ErrorLog::WriteLog(char *sz) {
		FILE *fout=fopen("log.txt","a");
		if (fout) {
			fprintf(fout,"%s",sz);
			fclose(fout);
		}
		//else : we are on a CD? -- who cares now?
	}